/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class JfxRuntime {
    private final String version;
    private final VersionID versionId;
    private final String path;
    private final String home;
    private static final String RT_JAR = "jfxrt.jar";

    protected static JfxRuntime runtimeForJRE(File file, String string) {
        String string2 = null;
        String string3 = null;
        if (string.startsWith("1.7")) {
            string2 = JfxRuntime.noDash(string.replaceFirst("1.7", "2.2"));
            string3 = file + File.separator + "lib" + File.separator;
        } else if (string.startsWith("1.8")) {
            string2 = JfxRuntime.noDash(string);
            string3 = file + File.separator + "lib" + File.separator + "ext" + File.separator;
        } else if (string.startsWith("9")) {
            // empty if block
        }
        if (string3 != null && new File(string3 + RT_JAR).exists()) {
            return new JfxRuntime(string2, file.toString(), string3);
        }
        return null;
    }

    private static String noDash(String string) {
        int n = string.indexOf("-");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private JfxRuntime(String string, String string2, String string3) {
        this.version = string;
        this.home = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
        this.path = string3.endsWith(File.separator) ? string3 : string3 + File.separator;
        this.versionId = new VersionID(string);
    }

    public boolean isExtensionJfx() {
        return this.path.endsWith("lib" + File.separator + "ext" + File.separator);
    }

    public String toString() {
        return "JavaFX " + this.version + " at: " + this.path;
    }

    public URL[] getURLs() {
        URL[] uRLArray = new URL[1];
        File file = this.getRuntimeJar();
        try {
            uRLArray[0] = file.getCanonicalFile().toURI().toURL();
        }
        catch (IOException iOException) {
            Trace.printException(iOException);
            return null;
        }
        return uRLArray;
    }

    private File getRuntimeJar() {
        return new File(this.path + RT_JAR);
    }

    public File getHome() {
        return new File(this.home);
    }

    public File getSecurityPolicy() {
        File file = new File(this.home, "lib/security/javafx.policy");
        if (file.canRead()) {
            return file;
        }
        return null;
    }

    public VersionID getProductVersion() {
        return this.versionId;
    }
}

