/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.AuthKey;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.trace.Trace;

public final class KeychainCredentialManager
extends CredentialManager {
    KeychainCredentialManager() {
    }

    public static synchronized CredentialManager getInstance() {
        if (instance == null) {
            instance = new KeychainCredentialManager();
        }
        return instance;
    }

    protected long getLoginSessionId() {
        return 1L;
    }

    protected boolean isPasswordStorageSupported() {
        return true;
    }

    public void saveCredential(AuthKey authKey, CredentialInfo credentialInfo) {
        if (credentialInfo.isPasswordSaveApproved()) {
            String string = authKey.getProtocolScheme();
            String string2 = authKey.getHost();
            int n = authKey.getPort();
            String string3 = authKey.getPrompt();
            String string4 = authKey.getScheme();
            boolean bl = authKey.isProxy();
            String string5 = credentialInfo.getUserName();
            char[] cArray = credentialInfo.getPassword();
            Trace.netPrintln("Saving credential for protocol=" + string + ", siteName=\"" + string2 + "\", port = " + n + ", prompt=" + string3 + ", scheme=" + string4 + ", isProxy = " + (authKey.isProxy() ? "yes" : "no"));
            KeychainCredentialManager.nativeAddPasswordToKeychain(bl, string, string2, n, string3, string4, string5, cArray);
        }
        super.saveCredential(authKey, credentialInfo);
    }

    private static native int nativeAddPasswordToKeychain(boolean var0, String var1, String var2, int var3, String var4, String var5, String var6, char[] var7);
}

